/*
 * Decompiled with CFR 0.152.
 */
package anon.client;

import anon.client.AbstractChannel;
import anon.client.AbstractDataChain;
import anon.client.DataChainSendOrderStructure;
import anon.client.InternalChannelMessageQueue;
import anon.client.MixPacket;
import anon.client.Multiplexer;
import anon.client.crypto.MixCipherChain;
import java.io.IOException;
import java.security.SecureRandom;
import logging.LogHolder;
import logging.LogType;

public abstract class AbstractDataChannel
extends AbstractChannel {
    protected final MixCipherChain m_mixCipherChain;
    private AbstractDataChain m_parentDataChain;
    protected final InternalChannelMessageQueue m_channelMessageQueue;
    private boolean m_bWithIntegrityCheck;
    private boolean m_bDebug = false;
    private static final SecureRandom ms_secureRandom = new SecureRandom();

    public AbstractDataChannel(int a_channelId, Multiplexer a_parentMultiplexer, AbstractDataChain a_parentDataChain, MixCipherChain a_mixCipherChain) {
        super(a_channelId, a_parentMultiplexer);
        this.m_parentDataChain = a_parentDataChain;
        this.m_mixCipherChain = a_mixCipherChain;
        this.m_channelMessageQueue = new InternalChannelMessageQueue();
        this.m_bWithIntegrityCheck = a_parentMultiplexer.isProtocolWithIntegrityCheck();
        this.m_bDebug = a_parentMultiplexer.isDebug();
    }

    public InternalChannelMessageQueue getChannelMessageQueue() {
        return this.m_channelMessageQueue;
    }

    public AbstractDataChain getDataChain() {
        return this.m_parentDataChain;
    }

    public MixCipherChain getMixCipherChain() {
        return this.m_mixCipherChain;
    }

    public void processReceivedPacket(MixPacket a_mixPacket) {
        if ((a_mixPacket.getChannelFlags() & 0x10) == 16) {
            LogHolder.log(6, LogType.NET, "AbstractDataChannel: processReceivedPacket(): Catched an unexpected dummy-paket on channel '" + Integer.toString(a_mixPacket.getChannelId()) + "'.");
        } else {
            this.handleReceivedPacket(a_mixPacket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextPacketRecommandedOutputBlocksize() {
        int recommandedSize = 0;
        MixCipherChain mixCipherChain = this.m_mixCipherChain;
        synchronized (mixCipherChain) {
            recommandedSize = MixPacket.getPayloadSize() - this.m_mixCipherChain.getNextPacketEncryptionOverhead();
        }
        return recommandedSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createAndSendMixPacket(DataChainSendOrderStructure a_order, short a_channelFlags) {
        MixPacket packet = this.createEmptyMixPacket();
        if (this.m_bDebug) {
            a_channelFlags = (short)(a_channelFlags | 0x20);
        }
        packet.setChannelFlags(a_channelFlags);
        MixCipherChain mixCipherChain = this.m_mixCipherChain;
        synchronized (mixCipherChain) {
            byte[] buff = new byte[MixPacket.getPayloadSize() - this.m_mixCipherChain.getNextPacketEncryptionOverhead()];
            ms_secureRandom.nextBytes(buff);
            a_order.setChannelCell(buff);
            if (a_order.getOrderData() != null) {
                this.m_parentDataChain.createPacketPayload(a_order);
            } else if (this.m_bWithIntegrityCheck) {
                a_order.getChannelCell()[0] = 0;
                a_order.getChannelCell()[1] = 0;
            }
            byte[] encryptedPacketPayload = this.m_mixCipherChain.encryptPacket(a_order.getChannelCell(), MixPacket.getPayloadSize(), packet.getSendCallbackHandlers());
            System.arraycopy(encryptedPacketPayload, 0, packet.getPayloadData(), 0, encryptedPacketPayload.length);
            try {
                this.sendPacket(packet);
            }
            catch (IOException e) {
                a_order.setThrownException(e);
            }
        }
        a_order.processingDone();
    }

    public abstract boolean processSendOrder(DataChainSendOrderStructure var1);

    public abstract void organizeChannelClose() throws IOException;

    protected abstract void handleReceivedPacket(MixPacket var1);
}

