/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.ByteSignature;
import anon.crypto.JAPCertificate;
import anon.util.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.pkcs.ContentInfo;
import org.bouncycastle.asn1.pkcs.IssuerAndSerialNumber;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.SignedData;
import org.bouncycastle.asn1.pkcs.SignerInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Certificate;

public class PKCS7SignedData
implements PKCSObjectIdentifiers {
    private int version;
    private int signerversion;
    private Hashtable digestalgos;
    private Vector certs;
    private JAPCertificate signCert;
    private byte[] digest;
    private String digestAlgorithm;
    private String digestEncryptionAlgorithm;
    private final String ID_MD5 = "1.2.840.113549.2.5";
    private final String ID_MD2 = "1.2.840.113549.2.2";
    private final String ID_SHA1 = "1.3.14.3.2.26";
    private final String ID_RSA = "1.2.840.113549.1.1.1";
    private final String ID_DSA = "1.2.840.10040.4.1";

    public PKCS7SignedData(byte[] in) throws SecurityException, InvalidKeyException, NoSuchAlgorithmException {
        ASN1Primitive pkcs;
        try {
            ASN1InputStream din = new ASN1InputStream(new ByteArrayInputStream(in));
            pkcs = din.readObject();
            Util.closeStream(din);
        }
        catch (IOException e) {
            throw new SecurityException("can't decode PKCS7SignedData object");
        }
        if (!(pkcs instanceof ASN1Sequence)) {
            throw new SecurityException("Not a valid PKCS#7 object - not a sequence");
        }
        ContentInfo content = ContentInfo.getInstance(pkcs);
        if (!content.getContentType().equals(PKCSObjectIdentifiers.signedData)) {
            throw new SecurityException("Not a valid PKCS#7 signed-data object - wrong header " + content.getContentType().getId());
        }
        SignedData sigdata = SignedData.getInstance(content.getContent());
        this.certs = new Vector();
        if (sigdata.getCertificates() != null) {
            Enumeration ec = ASN1Set.getInstance(sigdata.getCertificates()).getObjects();
            while (ec.hasMoreElements()) {
                JAPCertificate cert = null;
                try {
                    cert = JAPCertificate.getInstance(Certificate.getInstance(ec.nextElement()));
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (cert == null) continue;
                this.certs.addElement(cert);
            }
        }
        this.version = sigdata.getVersion().getValue().intValue();
        this.digestalgos = new Hashtable();
        Enumeration e = sigdata.getDigestAlgorithms().getObjects();
        while (e.hasMoreElements()) {
            ASN1Sequence s = (ASN1Sequence)e.nextElement();
            ASN1ObjectIdentifier o = (ASN1ObjectIdentifier)s.getObjectAt(0);
            this.digestalgos.put(o.getId(), o.getId());
        }
        ASN1Set signerinfos = sigdata.getSignerInfos();
        if (signerinfos.size() != 1) {
            throw new SecurityException("This PKCS#7 object has multiple SignerInfos - only one is supported at this time");
        }
        SignerInfo signerInfo = SignerInfo.getInstance(signerinfos.getObjectAt(0));
        this.signerversion = signerInfo.getVersion().getValue().intValue();
        IssuerAndSerialNumber isAnds = signerInfo.getIssuerAndSerialNumber();
        BigInteger serialNumber = isAnds.getCertificateSerialNumber().getValue();
        X500Name issuer = isAnds.getName();
        Enumeration enumer = this.certs.elements();
        while (enumer.hasMoreElements()) {
            JAPCertificate cert = (JAPCertificate)enumer.nextElement();
            boolean bS = serialNumber.equals(cert.getSerialNumber());
            if (!bS || !issuer.equals(cert.getIssuer().getX500Name())) continue;
            this.signCert = cert;
            break;
        }
        if (this.signCert == null) {
            throw new SecurityException("Can't find signing certificate with serial " + serialNumber.toString(16));
        }
        this.digestAlgorithm = signerInfo.getDigestAlgorithm().getAlgorithm().getId();
        this.digest = signerInfo.getEncryptedDigest().getOctets();
        this.digestEncryptionAlgorithm = signerInfo.getDigestEncryptionAlgorithm().getAlgorithm().getId();
        String algo = this.getDigestAlgorithm();
        if (!algo.equalsIgnoreCase("sha1withdsa")) {
            throw new NoSuchAlgorithmException("Signature Algorithm unknown!");
        }
    }

    public String getDigestAlgorithm() {
        String da = this.digestAlgorithm;
        String dea = this.digestEncryptionAlgorithm;
        if (this.digestAlgorithm.equals("1.2.840.113549.2.5")) {
            da = "MD5";
        } else if (this.digestAlgorithm.equals("1.2.840.113549.2.2")) {
            da = "MD2";
        } else if (this.digestAlgorithm.equals("1.3.14.3.2.26")) {
            da = "SHA1";
        }
        if (this.digestEncryptionAlgorithm.equals("1.2.840.113549.1.1.1")) {
            dea = "RSA";
        } else if (this.digestEncryptionAlgorithm.equals("1.2.840.10040.4.1")) {
            dea = "DSA";
        }
        return da + "with" + dea;
    }

    public JAPCertificate[] getCertificates() {
        Object[] tmp = new JAPCertificate[this.certs.size()];
        this.certs.copyInto(tmp);
        return tmp;
    }

    public JAPCertificate getSigningCertificate() {
        return this.signCert;
    }

    public int getVersion() {
        return this.version;
    }

    public int getSigningInfoVersion() {
        return this.signerversion;
    }

    public boolean verify(byte[] msg) throws SignatureException {
        return ByteSignature.verify(msg, this.digest, this.signCert.getPublicKey());
    }

    private ASN1Encodable getIssuer(byte[] enc) {
        try {
            ASN1InputStream in = new ASN1InputStream(new ByteArrayInputStream(enc));
            ASN1Sequence seq = (ASN1Sequence)in.readObject();
            in.close();
            return seq.getObjectAt(seq.getObjectAt(0) instanceof DERTaggedObject ? 3 : 2);
        }
        catch (IOException e) {
            throw new Error("IOException reading from ByteArray: " + e);
        }
    }
}

