/*
 * Decompiled with CFR 0.152.
 */
package anon.mixminion.message;

import anon.mixminion.message.ExitInformation;
import anon.mixminion.message.Header;
import anon.mixminion.message.MixMinionCryptoUtil;
import anon.mixminion.message.ReplyImplementation;
import anon.mixminion.mmrdescription.MMRDescription;
import anon.mixminion.mmrdescription.MMRList;
import anon.util.ByteArrayUtil;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public class NoReplyMessage
extends ReplyImplementation {
    private byte[][] m_message_parts;
    private int m_hops;
    private String[] m_recipient;
    private Vector m_start_server;
    private MMRList m_mmrlist;

    public NoReplyMessage(byte[][] message_parts, int hops, String[] recipient, MMRList mmrlist) {
        this.m_message_parts = message_parts;
        this.m_hops = hops;
        this.m_recipient = recipient;
        this.m_start_server = new Vector();
        this.m_mmrlist = mmrlist;
    }

    public Vector buildMessage() {
        Vector<byte[]> ready_to_send_Messages = new Vector<byte[]>();
        boolean isfragmented = this.m_message_parts.length > 1;
        Vector paths = new Vector();
        int firstleg_hops = this.m_hops / 2;
        int secondleg_hops = this.m_hops - firstleg_hops;
        if (!isfragmented) {
            Vector tv = this.m_mmrlist.getByRandomWithExit(this.m_hops);
            paths.addElement(tv);
        } else {
            paths = this.m_mmrlist.getByRandomWithFrag(this.m_hops, this.m_message_parts.length);
        }
        for (int i_frag = 0; i_frag < this.m_message_parts.length; ++i_frag) {
            int i;
            LogHolder.log(7, LogType.MISC, "[Message] make Header to Fragment_" + i_frag);
            Vector wholepath = (Vector)paths.elementAt(i_frag);
            Vector path1 = new Vector();
            Vector path2 = new Vector();
            path1 = MixMinionCryptoUtil.subVector(wholepath, 0, firstleg_hops);
            path2 = MixMinionCryptoUtil.subVector(wholepath, firstleg_hops, secondleg_hops);
            this.m_start_server.addElement((MMRDescription)path1.elementAt(0));
            Vector<byte[]> secrets1 = new Vector<byte[]>();
            Vector<byte[]> secrets2 = new Vector<byte[]>();
            for (int i2 = 0; i2 < this.m_hops / 2; ++i2) {
                secrets1.addElement(MixMinionCryptoUtil.randomArray(16));
                secrets2.addElement(MixMinionCryptoUtil.randomArray(16));
            }
            if (secrets2.size() < secondleg_hops) {
                secrets2.addElement(MixMinionCryptoUtil.randomArray(16));
            }
            ExitInformation exit2 = new ExitInformation();
            if (isfragmented) {
                exit2.m_Type = (short)259;
                exit2.m_Content = new byte[0];
            } else {
                exit2 = MMRDescription.getExitInformation(this.m_recipient, null);
            }
            ExitInformation exit1 = new ExitInformation();
            exit1.m_Type = (short)4;
            exit1.m_Content = ((MMRDescription)path2.elementAt((int)0)).getRoutingInformation().m_Content;
            Header header1 = new Header(path1, secrets1, exit1);
            Header header2 = new Header(path2, secrets2, exit2);
            byte[] headerbytes_1 = header1.getAsByteArray();
            byte[] headerbytes_2 = header2.getAsByteArray();
            byte[] payload = this.m_message_parts[i_frag];
            byte[] final_message = null;
            for (i = secrets2.size() - 1; i >= 0; --i) {
                byte[] secretKey = (byte[])secrets2.elementAt(i);
                byte[] key = MixMinionCryptoUtil.hash(ByteArrayUtil.conc(secretKey, "PAYLOAD ENCRYPT".getBytes()));
                payload = MixMinionCryptoUtil.SPRP_Encrypt(key, payload);
            }
            headerbytes_2 = MixMinionCryptoUtil.SPRP_Encrypt(MixMinionCryptoUtil.hash(ByteArrayUtil.conc(MixMinionCryptoUtil.hash(payload), "HIDE HEADER".getBytes())), headerbytes_2);
            payload = MixMinionCryptoUtil.SPRP_Encrypt(MixMinionCryptoUtil.hash(ByteArrayUtil.conc(MixMinionCryptoUtil.hash(headerbytes_2), "HIDE PAYLOAD".getBytes())), payload);
            for (i = secrets1.size() - 1; i >= 0; --i) {
                byte[] SK1_i = (byte[])secrets1.elementAt(i);
                headerbytes_2 = MixMinionCryptoUtil.SPRP_Encrypt(MixMinionCryptoUtil.hash(ByteArrayUtil.conc(SK1_i, "HEADER ENCRYPT".getBytes())), headerbytes_2);
                payload = MixMinionCryptoUtil.SPRP_Encrypt(MixMinionCryptoUtil.hash(ByteArrayUtil.conc(SK1_i, "PAYLOAD ENCRYPT".getBytes())), payload);
            }
            final_message = ByteArrayUtil.conc(headerbytes_1, headerbytes_2, payload);
            LogHolder.log(7, LogType.MISC, "[Message] the Messagesize = " + final_message.length + " Bytes");
            ready_to_send_Messages.addElement(final_message);
        }
        return ready_to_send_Messages;
    }

    public Vector getStartServers() {
        return this.m_start_server;
    }
}

