/*
 * Decompiled with CFR 0.152.
 */
package gui;

import anon.crypto.CertPathInfo;
import anon.crypto.JAPCertificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MultiCertTrustGraph {
    Hashtable m_rootNodes;
    Hashtable m_opNodes;
    Hashtable m_endNodes;

    public MultiCertTrustGraph(CertPathInfo[] a_infos) {
        this.createGraph(a_infos);
    }

    private void createGraph(CertPathInfo[] infos) {
        JAPCertificate end;
        JAPCertificate op;
        JAPCertificate root;
        int i;
        this.m_rootNodes = new Hashtable();
        this.m_opNodes = new Hashtable();
        this.m_endNodes = new Hashtable();
        for (i = 0; i < infos.length; ++i) {
            root = infos[i].getRootCertificate();
            op = infos[i].getSecondCertificate();
            end = infos[i].getFirstCertificate();
            if (root != null) {
                this.m_rootNodes.put(root, new Node(root, infos[i].isVerified(infos[i].getlength() - 1)));
            }
            if (op != null) {
                this.m_opNodes.put(op, new Node(op, infos[i].isVerified(1)));
            }
            this.m_endNodes.put(end, new Node(end, infos[i].isVerified(0)));
        }
        for (i = 0; i < infos.length; ++i) {
            Node parent;
            Node child;
            root = infos[i].getRootCertificate();
            op = infos[i].getSecondCertificate();
            end = infos[i].getFirstCertificate();
            if (op != null) {
                child = (Node)this.m_opNodes.get(op);
                if (root != null) {
                    parent = (Node)this.m_rootNodes.get(root);
                    parent.addChild(child);
                    this.m_opNodes.remove(op);
                }
                parent = child;
                child = (Node)this.m_endNodes.get(end);
                parent.addChild(child);
                this.m_endNodes.remove(end);
                continue;
            }
            if (root == null) continue;
            child = (Node)this.m_endNodes.get(end);
            parent = (Node)this.m_rootNodes.get(root);
            parent.addChild(child);
            this.m_endNodes.remove(end);
        }
    }

    public Enumeration getRootNodes() {
        return this.m_rootNodes.elements();
    }

    public Enumeration getOperatorNodes() {
        return this.m_opNodes.elements();
    }

    public Enumeration getEndNodes() {
        return this.m_endNodes.elements();
    }

    public int countTrustedRootNodes() {
        int count = 0;
        Enumeration rootNodes = this.getRootNodes();
        Date now = new Date();
        block0: while (rootNodes.hasMoreElements()) {
            Node current = (Node)rootNodes.nextElement();
            if (!current.isTrusted() || !current.getCertificate().getValidity().isValid(now) || !current.hasChildNodes()) continue;
            Enumeration childNodes = current.getChildNodes();
            while (childNodes.hasMoreElements()) {
                Node child = (Node)childNodes.nextElement();
                if (!child.getCertificate().getValidity().isValid(now)) continue;
                ++count;
                continue block0;
            }
        }
        return count;
    }

    public final class Node {
        private JAPCertificate m_cert;
        private Vector m_childNodes;
        private boolean m_trusted;

        public Node(JAPCertificate a_cert, boolean b_trusted) {
            this.m_cert = a_cert;
            this.m_trusted = b_trusted;
            this.m_childNodes = new Vector();
        }

        public void addChild(Node a_child) {
            if (!this.m_childNodes.contains(a_child)) {
                this.m_childNodes.addElement(a_child);
            }
        }

        public JAPCertificate getCertificate() {
            return this.m_cert;
        }

        public boolean isTrusted() {
            return this.m_trusted;
        }

        public Enumeration getChildNodes() {
            return this.m_childNodes.elements();
        }

        public boolean hasChildNodes() {
            return this.m_childNodes.size() > 0;
        }

        public int getWidth() {
            if (this.m_childNodes.size() == 0) {
                return 1;
            }
            return this.m_childNodes.size();
        }
    }
}

