/*
 * Decompiled with CFR 0.152.
 */
package jap;

import gui.AWTUpdateQueue;
import gui.JAPHelpContext;
import jap.IJAPConfSavePoint;
import jap.JAPConf;
import jap.JAPConfAnon;
import jap.JAPModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import logging.LogHolder;
import logging.LogType;

public abstract class AbstractJAPConfModule
implements JAPHelpContext.IHelpContext {
    private final AWTUpdateQueue AWT_UPDATE_QUEUE = new AWTUpdateQueue(new Runnable(){

        public void run() {
            try {
                AbstractJAPConfModule.this.onUpdateValues();
                AbstractJAPConfModule.this.m_rootPanel.validate();
            }
            catch (Throwable a_e) {
                LogHolder.log(1, LogType.GUI, a_e);
            }
        }
    });
    private JPanel m_rootPanel;
    protected IJAPConfSavePoint m_savePoint;
    private boolean m_bObserversInitialised = false;
    protected final Object LOCK_OBSERVABLE = new Object();

    protected AbstractJAPConfModule(IJAPConfSavePoint a_moduleSavePoint) {
        this.m_rootPanel = new JPanel();
        this.m_rootPanel.addAncestorListener(new RootPanelAncestorListener());
        this.m_savePoint = a_moduleSavePoint;
        this.recreateRootPanel();
        FontSizeObserver observer = new FontSizeObserver();
        JAPModel.getInstance().addObserver(observer);
        this.fontSizeChanged(new JAPModel.FontResize(JAPModel.getInstance().getFontSize(), JAPModel.getInstance().getFontSize()), observer.getDummyLabel());
    }

    public static GridBagConstraints createTabbedRootPanelContraints() {
        GridBagConstraints rootPanelConstraints = new GridBagConstraints();
        rootPanelConstraints.anchor = 18;
        rootPanelConstraints.fill = 1;
        rootPanelConstraints.weightx = 1.0;
        rootPanelConstraints.weighty = 1.0;
        rootPanelConstraints.gridx = 0;
        rootPanelConstraints.gridy = 0;
        return rootPanelConstraints;
    }

    public abstract String getTabTitle();

    public abstract void recreateRootPanel();

    public final JPanel getRootPanel() {
        return this.m_rootPanel;
    }

    public final void createSavePoint() {
        if (this.m_savePoint != null) {
            this.m_savePoint.createSavePoint();
        }
    }

    public final boolean okPressed() {
        return this.onOkPressed();
    }

    public void fontSizeChanged(JAPModel.FontResize a_fontResize, JLabel a_dummyLabel) {
    }

    public final void cancelPressed() {
        if (this.m_savePoint != null) {
            this.m_savePoint.restoreSavePoint();
        }
        this.onCancelPressed();
    }

    public final void resetToDefaultsPressed() {
        if (this.m_savePoint != null) {
            this.m_savePoint.restoreDefaults();
        }
        this.onResetToDefaultsPressed();
    }

    public final void updateValues(boolean a_bSync) {
        if (this instanceof JAPConfAnon) {
            // empty if block
        }
        this.AWT_UPDATE_QUEUE.update(a_bSync);
    }

    protected void onRootPanelShown() {
    }

    protected boolean onOkPressed() {
        return true;
    }

    protected void onCancelPressed() {
    }

    protected void onResetToDefaultsPressed() {
    }

    protected void onUpdateValues() {
    }

    protected boolean initObservers() {
        boolean bObserversInitialised = this.m_bObserversInitialised;
        this.m_bObserversInitialised = true;
        return !bObserversInitialised;
    }

    public Component getHelpExtractionDisplayContext() {
        return JAPConf.getInstance().getContentPane();
    }

    public abstract /* synthetic */ String getHelpContext();

    protected class FontSizeObserver
    implements Observer {
        private JLabel DUMMY_LABEL = new JLabel();

        protected FontSizeObserver() {
        }

        public JLabel getDummyLabel() {
            return this.DUMMY_LABEL;
        }

        public void update(Observable a_observable, Object a_message) {
            if (a_message instanceof JAPModel.FontResize && a_message != null) {
                SwingUtilities.updateComponentTreeUI(this.DUMMY_LABEL);
                AbstractJAPConfModule.this.fontSizeChanged((JAPModel.FontResize)a_message, this.DUMMY_LABEL);
            }
        }
    }

    private class RootPanelAncestorListener
    implements AncestorListener {
        private RootPanelAncestorListener() {
        }

        public void ancestorAdded(AncestorEvent event) {
            if (event.getAncestor() == AbstractJAPConfModule.this.getRootPanel() && AbstractJAPConfModule.this.getRootPanel().isVisible()) {
                AbstractJAPConfModule.this.onRootPanelShown();
            }
        }

        public void ancestorMoved(AncestorEvent event) {
        }

        public void ancestorRemoved(AncestorEvent event) {
        }
    }
}

