/*
 * Decompiled with CFR 0.152.
 */
package jap.pay;

import anon.pay.PayAccountsFile;
import anon.pay.PaymentInstanceDBEntry;
import anon.util.JAPMessages;
import gui.dialog.JAPDialog;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import logging.LogHolder;
import logging.LogType;

public class BISelectionDialog
extends JAPDialog
implements ActionListener,
ListSelectionListener {
    private JList m_biList;
    private JButton m_okButton;
    private JButton m_cancelButton;
    private JLabel m_biHost;
    private JLabel m_biPort;
    private PaymentInstanceDBEntry m_selectedBI;

    public BISelectionDialog(Component a_owner) {
        super(a_owner, JAPMessages.getString("biSelectionDialog"), true);
        this.setDefaultCloseOperation(2);
        this.jbInit();
        this.setSize(500, 400);
        this.setVisible(true);
    }

    private void jbInit() {
        JPanel panel1 = new JPanel(new GridBagLayout());
        JPanel bttnPanel = new JPanel(new FlowLayout(0));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 0;
        c.insets = new Insets(5, 5, 5, 5);
        this.m_biList = new JList();
        this.m_biList.addListSelectionListener(this);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 3;
        c.gridheight = 5;
        c.weighty = 1.0;
        c.fill = 1;
        panel1.add((Component)this.m_biList, c);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 0;
        c.gridx = 3;
        panel1.add((Component)new JLabel(JAPMessages.getString("infoAboutBI")), c);
        ++c.gridy;
        panel1.add((Component)new JLabel(JAPMessages.getString("biInfoHost")), c);
        this.m_biHost = new JLabel();
        ++c.gridx;
        panel1.add((Component)this.m_biHost, c);
        --c.gridx;
        ++c.gridy;
        panel1.add((Component)new JLabel(JAPMessages.getString("biInfoPort")), c);
        this.m_biPort = new JLabel();
        ++c.gridx;
        panel1.add((Component)this.m_biPort, c);
        this.m_cancelButton = new JButton(JAPMessages.getString("bttnCancel"));
        this.m_cancelButton.addActionListener(this);
        bttnPanel.add(this.m_cancelButton);
        this.m_okButton = new JButton(JAPMessages.getString("bttnOk"));
        this.m_okButton.addActionListener(this);
        bttnPanel.add(this.m_okButton);
        c.gridy = 5;
        c.gridx = 0;
        c.weightx = 1.0;
        c.gridwidth = 5;
        c.anchor = 14;
        panel1.add((Component)bttnPanel, c);
        this.getContentPane().add(panel1);
        DefaultListModel<String> model = new DefaultListModel<String>();
        model.addElement(JAPMessages.getString("loadingBIInfo1"));
        model.addElement(JAPMessages.getString("loadingBIInfo2"));
        this.m_biList.setModel(model);
        this.m_biList.setEnabled(false);
        Runnable fillList = new Runnable(){

            public void run() {
                DefaultListModel<PaymentInstanceDBEntry> listModel = new DefaultListModel<PaymentInstanceDBEntry>();
                try {
                    Vector paymentInstances = PayAccountsFile.getInstance().getPaymentInstances();
                    Enumeration en = paymentInstances.elements();
                    while (en.hasMoreElements()) {
                        listModel.addElement((PaymentInstanceDBEntry)en.nextElement());
                    }
                }
                catch (Exception e) {
                    LogHolder.log(2, LogType.PAY, e.getMessage());
                }
                BISelectionDialog.this.m_biList.setEnabled(true);
                BISelectionDialog.this.m_biList.setModel(listModel);
            }
        };
        Thread t = new Thread(fillList);
        t.setDaemon(true);
        t.start();
    }

    public PaymentInstanceDBEntry getSelectedBI() {
        return this.m_selectedBI;
    }

    public void actionPerformed(ActionEvent a_e) {
        if (a_e.getSource() == this.m_okButton) {
            this.m_selectedBI = (PaymentInstanceDBEntry)this.m_biList.getSelectedValue();
            this.dispose();
        } else if (a_e.getSource() == this.m_cancelButton) {
            this.dispose();
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.m_biList) {
            // empty if block
        }
    }
}

