/*
 * Decompiled with CFR 0.152.
 */
package jap.pay;

import anon.pay.BIConnection;
import anon.pay.PayAccount;
import anon.pay.PaymentInstanceDBEntry;
import anon.pay.xml.XMLErrorMessage;
import anon.pay.xml.XMLPassivePayment;
import anon.pay.xml.XMLPaymentOption;
import anon.pay.xml.XMLPaymentOptions;
import anon.pay.xml.XMLTransactionOverview;
import anon.util.IReturnRunnable;
import anon.util.IXMLEncodable;
import anon.util.JAPMessages;
import gui.GUIUtils;
import gui.JAPHtmlMultiLineLabel;
import gui.dialog.JAPDialog;
import gui.dialog.WorkerContentPane;
import jap.JAPController;
import jap.JAPUtil;
import jap.pay.AccountSettingsPanel;
import jap.pay.ActivePaymentDetails;
import jap.pay.PassivePaymentDetails;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import logging.LogHolder;
import logging.LogType;

public class TransactionOverviewDialog
extends JAPDialog
implements ActionListener {
    private static final String MSG_OK_BUTTON = (class$jap$pay$TransactionOverviewDialog == null ? (class$jap$pay$TransactionOverviewDialog = TransactionOverviewDialog.class$("jap.pay.TransactionOverviewDialog")) : class$jap$pay$TransactionOverviewDialog).getName() + "_ok_button";
    private static final String MSG_DETAILSBUTTON = (class$jap$pay$TransactionOverviewDialog == null ? (class$jap$pay$TransactionOverviewDialog = TransactionOverviewDialog.class$("jap.pay.TransactionOverviewDialog")) : class$jap$pay$TransactionOverviewDialog).getName() + "_detailsbutton";
    private static final String MSG_RELOADBUTTON = (class$jap$pay$TransactionOverviewDialog == null ? (class$jap$pay$TransactionOverviewDialog = TransactionOverviewDialog.class$("jap.pay.TransactionOverviewDialog")) : class$jap$pay$TransactionOverviewDialog).getName() + "_reloadbutton";
    private static final String MSG_CANCELBUTTON = (class$jap$pay$TransactionOverviewDialog == null ? (class$jap$pay$TransactionOverviewDialog = TransactionOverviewDialog.class$("jap.pay.TransactionOverviewDialog")) : class$jap$pay$TransactionOverviewDialog).getName() + "_cancelbutton";
    private static final String MSG_FETCHING = (class$jap$pay$TransactionOverviewDialog == null ? (class$jap$pay$TransactionOverviewDialog = TransactionOverviewDialog.class$("jap.pay.TransactionOverviewDialog")) : class$jap$pay$TransactionOverviewDialog).getName() + "_fetching";
    private static final String MSG_TAN = (class$jap$pay$TransactionOverviewDialog == null ? (class$jap$pay$TransactionOverviewDialog = TransactionOverviewDialog.class$("jap.pay.TransactionOverviewDialog")) : class$jap$pay$TransactionOverviewDialog).getName() + "_tan";
    private static final String MSG_AMOUNT = (class$jap$pay$TransactionOverviewDialog == null ? (class$jap$pay$TransactionOverviewDialog = TransactionOverviewDialog.class$("jap.pay.TransactionOverviewDialog")) : class$jap$pay$TransactionOverviewDialog).getName() + "_amount";
    private static final String MSG_STATUS = (class$jap$pay$TransactionOverviewDialog == null ? (class$jap$pay$TransactionOverviewDialog = TransactionOverviewDialog.class$("jap.pay.TransactionOverviewDialog")) : class$jap$pay$TransactionOverviewDialog).getName() + "_status";
    private static final String MSG_TRANSACTION_DATE = (class$jap$pay$TransactionOverviewDialog == null ? (class$jap$pay$TransactionOverviewDialog = TransactionOverviewDialog.class$("jap.pay.TransactionOverviewDialog")) : class$jap$pay$TransactionOverviewDialog).getName() + "_transaction_date";
    public static final String MSG_DETAILS_FAILED = (class$jap$pay$TransactionOverviewDialog == null ? (class$jap$pay$TransactionOverviewDialog = TransactionOverviewDialog.class$("jap.pay.TransactionOverviewDialog")) : class$jap$pay$TransactionOverviewDialog).getName() + "_details_failed";
    public static final String MSG_FETCHING_TAN = (class$jap$pay$TransactionOverviewDialog == null ? (class$jap$pay$TransactionOverviewDialog = TransactionOverviewDialog.class$("jap.pay.TransactionOverviewDialog")) : class$jap$pay$TransactionOverviewDialog).getName() + "_fetchingTAN";
    private static final String MSG_ACCOUNTNUMBER = (class$jap$pay$TransactionOverviewDialog == null ? (class$jap$pay$TransactionOverviewDialog = TransactionOverviewDialog.class$("jap.pay.TransactionOverviewDialog")) : class$jap$pay$TransactionOverviewDialog).getName() + "_accountnumber";
    private static final String MSG_VOLUMEPLAN = (class$jap$pay$TransactionOverviewDialog == null ? (class$jap$pay$TransactionOverviewDialog = TransactionOverviewDialog.class$("jap.pay.TransactionOverviewDialog")) : class$jap$pay$TransactionOverviewDialog).getName() + "_volumeplan";
    private static final String MSG_PAYMENTMETHOD = (class$jap$pay$TransactionOverviewDialog == null ? (class$jap$pay$TransactionOverviewDialog = TransactionOverviewDialog.class$("jap.pay.TransactionOverviewDialog")) : class$jap$pay$TransactionOverviewDialog).getName() + "_paymentmethod";
    private static final String MSG_USEDSTATUS = (class$jap$pay$TransactionOverviewDialog == null ? (class$jap$pay$TransactionOverviewDialog = TransactionOverviewDialog.class$("jap.pay.TransactionOverviewDialog")) : class$jap$pay$TransactionOverviewDialog).getName() + "_usedstatus";
    private static final String MSG_OPENSTATUS = (class$jap$pay$TransactionOverviewDialog == null ? (class$jap$pay$TransactionOverviewDialog = TransactionOverviewDialog.class$("jap.pay.TransactionOverviewDialog")) : class$jap$pay$TransactionOverviewDialog).getName() + "_openstatus";
    private static final String MSG_EXPIREDSTATUS = (class$jap$pay$TransactionOverviewDialog == null ? (class$jap$pay$TransactionOverviewDialog = TransactionOverviewDialog.class$("jap.pay.TransactionOverviewDialog")) : class$jap$pay$TransactionOverviewDialog).getName() + "_expiredstatus";
    private static final String MSG_PAYMENT_COMPLETED = (class$jap$pay$TransactionOverviewDialog == null ? (class$jap$pay$TransactionOverviewDialog = TransactionOverviewDialog.class$("jap.pay.TransactionOverviewDialog")) : class$jap$pay$TransactionOverviewDialog).getName() + "_paymentcompleted";
    private static final String MSG_PAYMENT_EXPIRED = (class$jap$pay$TransactionOverviewDialog == null ? (class$jap$pay$TransactionOverviewDialog = TransactionOverviewDialog.class$("jap.pay.TransactionOverviewDialog")) : class$jap$pay$TransactionOverviewDialog).getName() + "_paymentexpired";
    private static final String MSG_NO_OPEN_TRANSFERS = (class$jap$pay$TransactionOverviewDialog == null ? (class$jap$pay$TransactionOverviewDialog = TransactionOverviewDialog.class$("jap.pay.TransactionOverviewDialog")) : class$jap$pay$TransactionOverviewDialog).getName() + "_noopentransfers";
    private JTable m_transactionsTable;
    private JButton m_okButton;
    private JButton m_reloadButton;
    private JButton m_detailsButton;
    private JLabel m_fetchingLabel;
    private Vector m_accounts;
    static /* synthetic */ Class class$jap$pay$TransactionOverviewDialog;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$jap$pay$TransactionOverviewDialog$TablecellAmount;
    static /* synthetic */ Class class$java$lang$Object;

    public TransactionOverviewDialog(AccountSettingsPanel a_parent, String title, boolean modal, Vector a_accounts) {
        super(GUIUtils.getParentWindow(a_parent.getRootPanel()), title, modal);
        if (a_accounts.size() == 0) {
            JAPDialog.showMessageDialog(this, JAPMessages.getString(MSG_NO_OPEN_TRANSFERS));
        } else {
            try {
                this.m_accounts = a_accounts;
                this.setDefaultCloseOperation(2);
                this.buildDialog();
                this.setModal(true);
                this.setSize(700, 300);
                this.setVisible(true);
            }
            catch (Exception e) {
                LogHolder.log(2, LogType.PAY, "Could not create TransactionOverviewDialog: " + e.getMessage());
            }
        }
    }

    private void buildDialog() throws Exception {
        JPanel rootPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.insets = new Insets(5, 5, 5, 5);
        this.m_transactionsTable = new JTable();
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 1.0;
        c.fill = 1;
        rootPanel.add((Component)new JScrollPane(this.m_transactionsTable), c);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        ++c.gridy;
        this.m_fetchingLabel = new JLabel(JAPMessages.getString(MSG_FETCHING), GUIUtils.loadImageIcon("busy.gif", true), 10);
        this.m_fetchingLabel.setHorizontalTextPosition(10);
        rootPanel.add((Component)this.m_fetchingLabel, c);
        c.gridy = 5;
        c.gridx = 0;
        c.weightx = 1.0;
        c.anchor = 14;
        rootPanel.add((Component)this.buildButtonPanel(), c);
        this.getContentPane().add(rootPanel);
        this.showTransactions();
    }

    private JPanel buildButtonPanel() {
        JPanel bttnPanel = new JPanel(new FlowLayout(0));
        this.m_detailsButton = new JButton(JAPMessages.getString(MSG_DETAILSBUTTON));
        this.m_detailsButton.addActionListener(this);
        bttnPanel.add(this.m_detailsButton);
        this.m_reloadButton = new JButton(JAPMessages.getString(MSG_RELOADBUTTON));
        this.m_reloadButton.addActionListener(this);
        bttnPanel.add(this.m_reloadButton);
        this.m_okButton = new JButton(JAPMessages.getString(MSG_CANCELBUTTON));
        this.m_okButton.addActionListener(this);
        bttnPanel.add(this.m_okButton);
        return bttnPanel;
    }

    private void showTransactions() {
        this.m_reloadButton.setEnabled(false);
        this.m_fetchingLabel.setVisible(true);
        Runnable fillList = new Runnable(){

            public void run() {
                JAPController.getInstance().updatePaymentInstances(false);
                XMLTransactionOverview overview = new XMLTransactionOverview(JAPMessages.getLocale().getLanguage());
                Enumeration allAccounts = TransactionOverviewDialog.this.m_accounts.elements();
                while (allAccounts.hasMoreElements()) {
                    PayAccount curAccount = (PayAccount)allAccounts.nextElement();
                    if (curAccount.getTransaction() == null) continue;
                    overview.addTan(curAccount.getTransaction());
                }
                MyTableModel tableModel = new MyTableModel(overview);
                TransactionOverviewDialog.this.m_transactionsTable.setEnabled(true);
                TransactionOverviewDialog.this.m_transactionsTable.setModel(tableModel);
                TransactionOverviewDialog.this.m_transactionsTable.addMouseListener(new MouseAdapter(){

                    public void mouseClicked(MouseEvent e) {
                        if (e.getClickCount() == 2) {
                            TransactionOverviewDialog.this.showTransactionDetailsDialog();
                        }
                    }
                });
                TransactionOverviewDialog.this.m_okButton.setText(JAPMessages.getString(MSG_OK_BUTTON));
                TransactionOverviewDialog.this.m_fetchingLabel.setVisible(false);
                TransactionOverviewDialog.this.m_reloadButton.setEnabled(true);
            }
        };
        Thread t = new Thread(fillList, "TransactionOverviewDialog");
        t.setDaemon(true);
        t.start();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_okButton) {
            this.dispose();
        } else if (e.getSource() == this.m_reloadButton) {
            this.showTransactions();
        } else if (e.getSource() == this.m_detailsButton) {
            this.showTransactionDetailsDialog();
        }
    }

    public void showTransactionDetailsDialog() {
        try {
            int selectedRow = this.m_transactionsTable.getSelectedRow();
            final String transferNumber = (String)this.m_transactionsTable.getModel().getValueAt(selectedRow, 1);
            Object value = this.m_transactionsTable.getModel().getValueAt(selectedRow, 3);
            long amount = ((TablecellAmount)value).getLongValue();
            String status = (String)this.m_transactionsTable.getModel().getValueAt(selectedRow, 6);
            String planName = (String)this.m_transactionsTable.getModel().getValueAt(selectedRow, 4);
            String paymentMethod = (String)this.m_transactionsTable.getModel().getValueAt(selectedRow, 5);
            boolean isCompleted = false;
            boolean isExpired = false;
            if (status.equalsIgnoreCase(JAPMessages.getString(MSG_USEDSTATUS))) {
                isCompleted = true;
            } else if (status.equalsIgnoreCase(JAPMessages.getString(MSG_EXPIREDSTATUS))) {
                isExpired = true;
            }
            final PayAccount m_account = (PayAccount)this.m_accounts.elementAt(0);
            JAPDialog dialog = new JAPDialog(this, JAPMessages.getString(MSG_FETCHING_TAN));
            IReturnRunnable run2 = new IReturnRunnable(){
                Object xmlReply;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    PaymentInstanceDBEntry bi = m_account.getBI();
                    BIConnection biConn = null;
                    try {
                        try {
                            biConn = new BIConnection(bi);
                            biConn.connect();
                            biConn.authenticate(m_account);
                            this.xmlReply = biConn.fetchPaymentData(new Long(transferNumber).toString(), m_account);
                        }
                        catch (Exception a_e) {
                            this.xmlReply = a_e;
                            Object var5_4 = null;
                            if (biConn != null) {
                                biConn.disconnect();
                            }
                        }
                        Object var5_3 = null;
                        if (biConn != null) {
                            biConn.disconnect();
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        if (biConn != null) {
                            biConn.disconnect();
                        }
                        throw throwable;
                    }
                }

                public Object getValue() {
                    return this.xmlReply;
                }
            };
            WorkerContentPane pane2 = new WorkerContentPane(dialog, JAPMessages.getString(MSG_FETCHING_TAN), run2);
            pane2.updateDialog();
            dialog.pack();
            dialog.setVisible(true);
            if (run2.getValue() == null) {
                return;
            }
            if (run2.getValue() instanceof Exception && !(run2.getValue() instanceof XMLErrorMessage)) {
                throw (Exception)run2.getValue();
            }
            if (!(run2.getValue() instanceof IXMLEncodable)) {
                throw new Exception("Illegal return value!");
            }
            IXMLEncodable xmlReply = (IXMLEncodable)run2.getValue();
            if (xmlReply instanceof XMLErrorMessage) {
                XMLErrorMessage repliedMessage = (XMLErrorMessage)xmlReply;
                if (repliedMessage.getXmlErrorCode() == 19) {
                    if (isCompleted) {
                        JAPDialog.showMessageDialog(this, JAPMessages.getString(MSG_PAYMENT_COMPLETED));
                    } else if (isExpired) {
                        JAPDialog.showMessageDialog(this, JAPMessages.getString(MSG_PAYMENT_EXPIRED));
                    } else {
                        TransactionOverviewDialog.showActivePaymentDialog(this, transferNumber, amount, m_account, planName, paymentMethod, true);
                    }
                } else {
                    JAPDialog.showMessageDialog(this, JAPMessages.getString(MSG_DETAILS_FAILED));
                }
            } else {
                TransactionOverviewDialog.showPassivePaymentDialog(this, (XMLPassivePayment)xmlReply, Long.parseLong(transferNumber), m_account.getAccountNumber());
            }
        }
        catch (Exception e) {
            LogHolder.log(7, LogType.PAY, "could not get transaction details");
        }
    }

    public static void showActivePaymentDialog(JAPDialog a_parent, String transferNumber, long amount, final PayAccount a_account, String planName, final String a_paymentMethod, final boolean a_bForce) {
        IReturnRunnable run = new IReturnRunnable(){
            Vector optionsToShow;

            public void run() {
                this.optionsToShow = TransactionOverviewDialog.getLocalizedActivePaymentsData(JAPMessages.getLocale().getLanguage(), a_account, a_paymentMethod);
            }

            public Object getValue() {
                return this.optionsToShow;
            }
        };
        JAPDialog dialog = new JAPDialog(a_parent, JAPMessages.getString(AccountSettingsPanel.MSG_FETCHINGOPTIONS));
        Runnable run2 = new Runnable(){

            public void run() {
                try {
                    a_account.fetchAccountInfo(true);
                }
                catch (Exception e) {
                    LogHolder.log(1, LogType.PAY, e);
                }
            }
        };
        WorkerContentPane pane2 = new WorkerContentPane(dialog, JAPMessages.getString(AccountSettingsPanel.MSG_GETACCOUNTSTATEMENT), run2);
        WorkerContentPane pane = new WorkerContentPane(dialog, JAPMessages.getString(AccountSettingsPanel.MSG_FETCHINGOPTIONS), pane2, run){

            public boolean isSkippedAsNextContentPane() {
                return !a_bForce && a_account.isCharged();
            }
        };
        pane.pack();
        dialog.setResizable(false);
        dialog.setVisible(true);
        if (run.getValue() != null && ((Vector)run.getValue()).size() > 0) {
            ActivePaymentDetails apd = new ActivePaymentDetails(a_parent, (Vector)run.getValue(), transferNumber, amount, planName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Vector getLocalizedActivePaymentsData(String lang, PayAccount a_account, String a_paymentMethod) {
        Vector optionsToShow = new Vector();
        if (a_account == null || a_account.getBI() == null) {
            return optionsToShow;
        }
        PaymentInstanceDBEntry theJPI = a_account.getBI();
        BIConnection biConn = null;
        try {
            try {
                biConn = new BIConnection(theJPI);
                biConn.connect();
                biConn.authenticate(a_account);
                XMLPaymentOptions allOptions = biConn.fetchPaymentOptions();
                if (lang.equals("")) {
                    lang = "en";
                }
                Enumeration options = allOptions.getAllOptions().elements();
                while (options.hasMoreElements()) {
                    XMLPaymentOption curOption = (XMLPaymentOption)options.nextElement();
                    if (curOption.getType().equals("passive") || !curOption.worksWithJapVersion("00.20.010")) continue;
                    Hashtable<String, Object> curOptionData = new Hashtable<String, Object>();
                    curOptionData.put("name", curOption.getName());
                    curOptionData.put("heading", new JAPHtmlMultiLineLabel(curOption.getHeading(lang)).getHTMLDocumentText());
                    curOptionData.put("detailedInfo", new JAPHtmlMultiLineLabel(curOption.getDetailedInfo(lang)).getHTMLDocumentText());
                    curOptionData.put("extraInfos", curOption.getLocalizedExtraInfoText(lang));
                    optionsToShow.addElement(curOptionData);
                }
                Object var11_11 = null;
                if (biConn != null) {
                    biConn.disconnect();
                }
            }
            catch (Exception e) {
                LogHolder.log(7, LogType.PAY, "could not get payment options");
                Object var11_12 = null;
                if (biConn != null) {
                    biConn.disconnect();
                }
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (biConn != null) {
                biConn.disconnect();
            }
            throw throwable;
        }
        return optionsToShow;
    }

    public static void showPassivePaymentDialog(JAPDialog a_parent, XMLPassivePayment pp, long transfernumber, long accountnumber) {
        PassivePaymentDetails ppd = new PassivePaymentDetails(a_parent, pp, transfernumber, accountnumber);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class TablecellAmount {
        long m_theAmount;

        public TablecellAmount(long amount) {
            this.m_theAmount = amount;
        }

        public String toString() {
            return JAPUtil.formatEuroCentValue(this.m_theAmount, true);
        }

        public long getLongValue() {
            return this.m_theAmount;
        }
    }

    private class MyTableModel
    extends AbstractTableModel {
        private XMLTransactionOverview m_overview;

        public MyTableModel(XMLTransactionOverview a_overview) {
            this.m_overview = a_overview;
        }

        public int getColumnCount() {
            return 7;
        }

        public int getRowCount() {
            return this.m_overview.size();
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 0: {
                    return class$java$lang$String == null ? (class$java$lang$String = TransactionOverviewDialog.class$("java.lang.String")) : class$java$lang$String;
                }
                case 1: {
                    return class$java$lang$String == null ? (class$java$lang$String = TransactionOverviewDialog.class$("java.lang.String")) : class$java$lang$String;
                }
                case 2: {
                    return class$java$util$Date == null ? (class$java$util$Date = TransactionOverviewDialog.class$("java.util.Date")) : class$java$util$Date;
                }
                case 3: {
                    return class$jap$pay$TransactionOverviewDialog$TablecellAmount == null ? (class$jap$pay$TransactionOverviewDialog$TablecellAmount = TransactionOverviewDialog.class$("jap.pay.TransactionOverviewDialog$TablecellAmount")) : class$jap$pay$TransactionOverviewDialog$TablecellAmount;
                }
                case 5: {
                    return class$java$lang$String == null ? (class$java$lang$String = TransactionOverviewDialog.class$("java.lang.String")) : class$java$lang$String;
                }
                case 6: {
                    return class$java$lang$String == null ? (class$java$lang$String = TransactionOverviewDialog.class$("java.lang.String")) : class$java$lang$String;
                }
                case 7: {
                    return class$java$lang$String == null ? (class$java$lang$String = TransactionOverviewDialog.class$("java.lang.String")) : class$java$lang$String;
                }
            }
            return class$java$lang$Object == null ? (class$java$lang$Object = TransactionOverviewDialog.class$("java.lang.Object")) : class$java$lang$Object;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            Hashtable transactionData = (Hashtable)this.m_overview.getTans().elementAt(rowIndex);
            switch (columnIndex) {
                case 0: {
                    String accountNumber = (String)transactionData.get("accountnumber");
                    if (accountNumber == null) {
                        return new String("");
                    }
                    return accountNumber;
                }
                case 1: {
                    return transactionData.get("tan");
                }
                case 2: {
                    try {
                        String dateAsString = (String)transactionData.get("date");
                        long dateAsMillis = Long.parseLong(dateAsString);
                        return new Date(dateAsMillis);
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
                case 3: {
                    try {
                        String amountString = (String)transactionData.get("amount");
                        long amount = Long.parseLong(amountString);
                        TablecellAmount theAmount = new TablecellAmount(amount);
                        return theAmount;
                    }
                    catch (Exception e) {
                        return new String("");
                    }
                }
                case 4: {
                    try {
                        String volumePlan = (String)transactionData.get("volumeplan");
                        return volumePlan;
                    }
                    catch (Exception e) {
                        return new String("");
                    }
                }
                case 5: {
                    try {
                        String paymentMethod = (String)transactionData.get("paymentmethod");
                        if (paymentMethod.equalsIgnoreCase("null")) {
                            return new String("");
                        }
                        return "<html>" + paymentMethod + "</html>";
                    }
                    catch (Exception e) {
                        return new String("");
                    }
                }
                case 6: {
                    try {
                        return this.transactionStatus(transactionData);
                    }
                    catch (Exception e) {
                        return new String("");
                    }
                }
            }
            return JAPMessages.getString("unknown");
        }

        private String transactionStatus(Hashtable a_transactionData) {
            String used = (String)a_transactionData.get("used");
            boolean isUsed = new Boolean(used);
            if (isUsed) {
                return JAPMessages.getString(MSG_USEDSTATUS);
            }
            return JAPMessages.getString(MSG_OPENSTATUS);
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return JAPMessages.getString(MSG_ACCOUNTNUMBER);
                }
                case 1: {
                    return JAPMessages.getString(MSG_TAN);
                }
                case 2: {
                    return JAPMessages.getString(MSG_TRANSACTION_DATE);
                }
                case 3: {
                    return JAPMessages.getString(MSG_AMOUNT);
                }
                case 4: {
                    return JAPMessages.getString(MSG_VOLUMEPLAN);
                }
                case 5: {
                    return JAPMessages.getString(MSG_PAYMENTMETHOD);
                }
                case 6: {
                    return JAPMessages.getString(MSG_STATUS);
                }
            }
            return "---";
        }

        public boolean isCellEditable(int col, int row) {
            return false;
        }
    }
}

