/*
 * Decompiled with CFR 0.152.
 */
package jap.pay.wizardnew;

import anon.pay.xml.XMLPaymentOption;
import anon.pay.xml.XMLTransCert;
import anon.platform.AbstractOS;
import anon.util.JAPMessages;
import anon.util.Util;
import gui.GUIUtils;
import gui.LinkMouseListener;
import gui.dialog.DialogContentPane;
import gui.dialog.DialogContentPaneOptions;
import gui.dialog.JAPDialog;
import gui.dialog.WorkerContentPane;
import jap.JAPController;
import jap.JAPUtil;
import jap.pay.wizardnew.MethodSelectionPane;
import jap.pay.wizardnew.VolumePlanSelectionPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import logging.LogHolder;
import logging.LogType;

public class PaymentInfoPane
extends DialogContentPane
implements DialogContentPane.IWizardSuitable,
ActionListener {
    private static final String MSG_INFOS = (class$jap$pay$wizardnew$PaymentInfoPane == null ? (class$jap$pay$wizardnew$PaymentInfoPane = PaymentInfoPane.class$("jap.pay.wizardnew.PaymentInfoPane")) : class$jap$pay$wizardnew$PaymentInfoPane).getName() + "_infos";
    private static final String MSG_BUTTONCOPY = (class$jap$pay$wizardnew$PaymentInfoPane == null ? (class$jap$pay$wizardnew$PaymentInfoPane = PaymentInfoPane.class$("jap.pay.wizardnew.PaymentInfoPane")) : class$jap$pay$wizardnew$PaymentInfoPane).getName() + "_buttoncopy";
    private static final String MSG_BUTTONOPEN = (class$jap$pay$wizardnew$PaymentInfoPane == null ? (class$jap$pay$wizardnew$PaymentInfoPane = PaymentInfoPane.class$("jap.pay.wizardnew.PaymentInfoPane")) : class$jap$pay$wizardnew$PaymentInfoPane).getName() + "_buttonopen";
    public static final String MSG_PAYPAL_ITEM_NAME = (class$jap$pay$wizardnew$PaymentInfoPane == null ? (class$jap$pay$wizardnew$PaymentInfoPane = PaymentInfoPane.class$("jap.pay.wizardnew.PaymentInfoPane")) : class$jap$pay$wizardnew$PaymentInfoPane).getName() + "_paypalitemname";
    private static final String MSG_COULD_OPEN = (class$jap$pay$wizardnew$PaymentInfoPane == null ? (class$jap$pay$wizardnew$PaymentInfoPane = PaymentInfoPane.class$("jap.pay.wizardnew.PaymentInfoPane")) : class$jap$pay$wizardnew$PaymentInfoPane).getName() + "_reminderLink";
    private static final String MSG_REMINDER_PAYMENT = (class$jap$pay$wizardnew$PaymentInfoPane == null ? (class$jap$pay$wizardnew$PaymentInfoPane = PaymentInfoPane.class$("jap.pay.wizardnew.PaymentInfoPane")) : class$jap$pay$wizardnew$PaymentInfoPane).getName() + "_reminderPayment";
    private static final String MSG_REMINDER_PAYMENT_EXPLAIN = (class$jap$pay$wizardnew$PaymentInfoPane == null ? (class$jap$pay$wizardnew$PaymentInfoPane = PaymentInfoPane.class$("jap.pay.wizardnew.PaymentInfoPane")) : class$jap$pay$wizardnew$PaymentInfoPane).getName() + "_reminderPaymentExplain";
    private static final String MSG_EXPLAIN_COULD_OPEN = (class$jap$pay$wizardnew$PaymentInfoPane == null ? (class$jap$pay$wizardnew$PaymentInfoPane = PaymentInfoPane.class$("jap.pay.wizardnew.PaymentInfoPane")) : class$jap$pay$wizardnew$PaymentInfoPane).getName() + "_reminderLinkExplain";
    private static final String MSG_NO_FURTHER_PAYMENT = (class$jap$pay$wizardnew$PaymentInfoPane == null ? (class$jap$pay$wizardnew$PaymentInfoPane = PaymentInfoPane.class$("jap.pay.wizardnew.PaymentInfoPane")) : class$jap$pay$wizardnew$PaymentInfoPane).getName() + "_noFurtherPayment";
    private static final String MSG_USE_OTHER_METHOD = (class$jap$pay$wizardnew$PaymentInfoPane == null ? (class$jap$pay$wizardnew$PaymentInfoPane = PaymentInfoPane.class$("jap.pay.wizardnew.PaymentInfoPane")) : class$jap$pay$wizardnew$PaymentInfoPane).getName() + "_useOtherMethod";
    private Container m_rootPanel;
    private GridBagConstraints m_c;
    private JButton m_bttnCopy;
    private JButton m_bttnOpen;
    private String m_language;
    private XMLPaymentOption m_selectedOption;
    private XMLTransCert m_transCert;
    private JCheckBox m_linkOpenedInBrowser;
    private JLabel m_imageLabel;
    private LinkMouseListener.ILinkGenerator m_paymentLinkGenerator;
    private boolean m_bURL;
    static /* synthetic */ Class class$jap$pay$wizardnew$PaymentInfoPane;
    static /* synthetic */ Class class$jap$JAPConstants;

    public PaymentInfoPane(JAPDialog a_parentDialog, DialogContentPane a_previousContentPane) {
        super(a_parentDialog, "Dummy", new DialogContentPane.Layout(JAPMessages.getString(MSG_INFOS), -1), new DialogContentPaneOptions(2, a_previousContentPane));
        this.setDefaultButtonOperation(266);
        this.m_language = JAPMessages.getLocale().getLanguage();
        this.m_rootPanel = this.getContentPane();
        this.m_rootPanel.setLayout(new GridBagLayout());
        this.m_c = new GridBagConstraints();
        this.m_c.gridx = 0;
        this.m_c.gridy = 0;
        this.m_c.weightx = 0.0;
        this.m_c.weightx = 0.0;
        this.m_c.insets = new Insets(5, 5, 5, 5);
        this.m_c.anchor = 18;
        this.m_c.fill = 0;
        this.m_linkOpenedInBrowser = new JCheckBox(JAPMessages.getString(MSG_COULD_OPEN));
        this.m_rootPanel.add((Component)this.m_linkOpenedInBrowser, this.m_c);
    }

    public static String createPaysafecardLink(String baseLink, long intAmount, String transferNumber) {
        baseLink = Util.replaceAll(baseLink, "%t", transferNumber);
        String pscAmount = PaymentInfoPane.amountAsString(intAmount);
        baseLink = Util.replaceAll(baseLink, "%a", pscAmount);
        baseLink = Util.replaceAll(baseLink, "%l", JAPMessages.getLocale().getLanguage());
        baseLink = Util.replaceAll(baseLink, "%c", "EUR");
        return baseLink;
    }

    public static String createPaypalLink(String baseLink, long amount, String planName, String transferNumber) {
        String paypalCurrency = "EUR";
        String paypalAmount = PaymentInfoPane.amountAsString(amount);
        String localeLang = JAPMessages.getLocale().getLanguage().toLowerCase();
        String paypalItem = JAPMessages.getString(MSG_PAYPAL_ITEM_NAME) + "%20-%20" + planName;
        baseLink = Util.replaceAll(baseLink, "%t", transferNumber);
        baseLink = Util.replaceAll(baseLink, "%item%", paypalItem);
        baseLink = Util.replaceAll(baseLink, "%amount%", paypalAmount);
        baseLink = Util.replaceAll(baseLink, "%currency%", paypalCurrency);
        localeLang = localeLang.startsWith("de") || localeLang.startsWith("fr") || localeLang.startsWith("es") || localeLang.startsWith("it") || localeLang.startsWith("au") || localeLang.startsWith("cn") || localeLang.startsWith("gb") || localeLang.startsWith("jp") || localeLang.startsWith("nl") ? localeLang.toUpperCase() : "US";
        baseLink = Util.replaceAll(baseLink, "%lang%", localeLang);
        return baseLink;
    }

    public static String createEgoldLink(String baseLink, long amount, String planName, String transferNumber) {
        String amountString = PaymentInfoPane.amountAsString(amount);
        String localeLang = JAPMessages.getLocale().getLanguage();
        String landingPageLang = localeLang.toLowerCase();
        if (!landingPageLang.equals("en") && !landingPageLang.equals("de")) {
            landingPageLang = "en";
        }
        String itemStrg = JAPMessages.getString(MSG_PAYPAL_ITEM_NAME) + "%20-%20" + planName;
        baseLink = Util.replaceAll(baseLink, "%t", transferNumber);
        baseLink = Util.replaceAll(baseLink, "%item%", itemStrg);
        baseLink = Util.replaceAll(baseLink, "%amount%", amountString);
        baseLink = Util.replaceAll(baseLink, "%currency%", "EUR");
        baseLink = Util.replaceAll(baseLink, "%2fen%2f", "%2f" + landingPageLang + "%2f");
        return baseLink;
    }

    private static String amountAsString(long amount) {
        String amountFractions;
        String amountWhole;
        String amountString = new Long(amount).toString();
        amountString.trim();
        if (amountString.length() == 1) {
            amountWhole = "0";
            amountFractions = "0" + amountString;
        } else if (amountString.length() < 3) {
            amountWhole = "0";
            amountFractions = amountString;
        } else {
            amountWhole = amountString.substring(0, amountString.length() - 2);
            amountFractions = amountString.substring(amountString.length() - 2, amountString.length());
        }
        String result = amountWhole + "%2e" + amountFractions;
        return result;
    }

    public void showInfo() {
        DialogContentPane somePreviousPane = this.getPreviousContentPane();
        while (!(somePreviousPane instanceof MethodSelectionPane)) {
            somePreviousPane = somePreviousPane.getPreviousContentPane();
        }
        MethodSelectionPane msp = (MethodSelectionPane)somePreviousPane;
        XMLPaymentOption selectedOption = msp.getSelectedPaymentOption();
        somePreviousPane = this.getPreviousContentPane();
        do {
            if (!(somePreviousPane instanceof WorkerContentPane) || !(((WorkerContentPane)somePreviousPane).getValue() instanceof XMLTransCert)) continue;
            this.m_transCert = (XMLTransCert)((WorkerContentPane)somePreviousPane).getValue();
            break;
        } while (this.m_transCert == null && (somePreviousPane = somePreviousPane.getPreviousContentPane()) != null);
        if (this.m_transCert == null) {
            throw new NullPointerException("TransCert is null!");
        }
        String htmlExtraInfo = "";
        this.m_selectedOption = selectedOption;
        this.m_rootPanel.removeAll();
        this.m_rootPanel = this.getContentPane();
        this.m_rootPanel.setLayout(new GridBagLayout());
        this.m_c = new GridBagConstraints();
        this.m_c.gridx = 0;
        this.m_c.gridy = 0;
        this.m_c.weightx = 0.0;
        this.m_c.weightx = 0.0;
        this.m_c.insets = new Insets(5, 5, 5, 5);
        this.m_c.anchor = 18;
        this.m_c.fill = 0;
        final String strExtraInfo = selectedOption.getExtraInfo(this.m_language);
        this.m_bURL = selectedOption.getExtraInfoType(this.m_language).equalsIgnoreCase("link");
        if (strExtraInfo != null) {
            somePreviousPane = this.getPreviousContentPane();
            while (!(somePreviousPane instanceof VolumePlanSelectionPane)) {
                somePreviousPane = somePreviousPane.getPreviousContentPane();
            }
            VolumePlanSelectionPane planPane = (VolumePlanSelectionPane)somePreviousPane;
            String amountString = planPane.getAmount();
            final String strOptionName = selectedOption.getName();
            final String planName = planPane.getSelectedVolumePlan().getDisplayName();
            final int intAmount = Integer.parseInt(amountString);
            final String tan = String.valueOf(this.m_transCert.getTransferNumber());
            this.m_paymentLinkGenerator = new LinkMouseListener.ILinkGenerator(){

                public String createLink() {
                    String link;
                    if (PaymentInfoPane.this.m_bURL) {
                        link = strOptionName.toLowerCase().indexOf("paypal") != -1 ? PaymentInfoPane.createPaypalLink(strExtraInfo, intAmount, planName, tan) : PaymentInfoPane.createPaysafecardLink(strExtraInfo, intAmount, tan);
                    } else {
                        link = Util.replaceAll(strExtraInfo, "%t", tan);
                        String amount = JAPUtil.formatEuroCentValue(intAmount, true);
                        link = Util.replaceAll(link, "%a", amount);
                        link = Util.replaceAll(link, "%c", "");
                    }
                    return link;
                }
            };
            ++this.m_c.gridy;
            this.m_rootPanel.add((Component)new JLabel(" "), this.m_c);
            String imageFilename = PaymentInfoPane.getMethodImageFilename(selectedOption.getName());
            ImageIcon methodImage = GUIUtils.loadImageIcon(imageFilename, false, false);
            ++this.m_c.gridy;
            if (methodImage != null) {
                JPanel imagePanel = new JPanel();
                imagePanel.setLayout(new BoxLayout(imagePanel, 0));
                this.m_imageLabel = new JLabel(methodImage);
                this.m_imageLabel.setAlignmentX(0.5f);
                if (strExtraInfo.indexOf("://") > 0 || strExtraInfo.toLowerCase().startsWith("mailto:")) {
                    this.m_imageLabel.addMouseListener(new LinkMouseListener(this.m_paymentLinkGenerator){

                        public void mouseClicked(MouseEvent a_event) {
                            super.mouseClicked(a_event);
                            PaymentInfoPane.this.actionPerformed(null);
                        }
                    });
                }
                imagePanel.add(this.m_imageLabel);
                this.m_c.gridwidth = 2;
                this.m_rootPanel.add((Component)imagePanel, this.m_c);
                this.m_c.gridwidth = 1;
                ++this.m_c.gridy;
            }
            this.m_bttnOpen = new JButton(JAPMessages.getString(MSG_BUTTONOPEN));
            this.m_bttnOpen.addActionListener(this);
            this.m_rootPanel.add((Component)this.m_bttnOpen, this.m_c);
            this.m_bttnOpen.setVisible(false);
            ++this.m_c.gridx;
            this.m_bttnCopy = new JButton(JAPMessages.getString(MSG_BUTTONCOPY));
            this.m_bttnCopy.addActionListener(this);
            this.m_rootPanel.add((Component)this.m_bttnCopy, this.m_c);
            this.m_bttnCopy.setEnabled(false);
            if (this.m_bURL) {
                this.m_bttnOpen.setVisible(true);
                this.m_bttnOpen.setEnabled(true);
                htmlExtraInfo = selectedOption.getDetailedInfo(this.m_language);
            } else {
                this.m_bttnCopy.setEnabled(true);
                htmlExtraInfo = selectedOption.getDetailedInfo(this.m_language) + "<br><b>" + this.m_paymentLinkGenerator.createLink() + "</b>";
            }
        }
        this.m_c.gridx = 0;
        ++this.m_c.gridy;
        this.m_rootPanel.add((Component)new JLabel(" "), this.m_c);
        this.setText(htmlExtraInfo);
        ++this.m_c.gridy;
        this.m_c.anchor = 15;
        this.m_c.gridwidth = 2;
        this.m_rootPanel.add((Component)this.m_linkOpenedInBrowser, this.m_c);
        if (this.m_bURL) {
            this.m_linkOpenedInBrowser.setText(JAPMessages.getString(MSG_COULD_OPEN));
        } else {
            this.m_linkOpenedInBrowser.setText(JAPMessages.getString(MSG_REMINDER_PAYMENT));
        }
    }

    public XMLTransCert getTransCert() {
        return this.m_transCert;
    }

    public static String getMethodImageFilename(String a_methodName) {
        String path;
        Class japConstantsClass = class$jap$JAPConstants == null ? (class$jap$JAPConstants = PaymentInfoPane.class$("jap.JAPConstants")) : class$jap$JAPConstants;
        String imageFieldName = "IMAGE_" + a_methodName.toUpperCase();
        Field pathVar = null;
        try {
            pathVar = japConstantsClass.getDeclaredField(imageFieldName);
        }
        catch (NoSuchFieldException nsfe) {
            LogHolder.log(7, LogType.PAY, "could not load image for payment method " + a_methodName + ", there is not variable " + imageFieldName + " in JAPConstants");
            return null;
        }
        try {
            path = (String)pathVar.get(null);
        }
        catch (Exception e) {
            LogHolder.log(7, LogType.PAY, "could not load image for payment method" + a_methodName + " , reason: " + e);
            return null;
        }
        return path;
    }

    private void copyExtraInfoToClipboard() {
        Clipboard sysClip = Toolkit.getDefaultToolkit().getSystemClipboard();
        String extraInfoString = this.m_paymentLinkGenerator.createLink();
        if (this.m_selectedOption.getExtraInfoType(this.m_language).equalsIgnoreCase("text")) {
            extraInfoString = Util.replaceAll(extraInfoString, "<br>", "\n");
            extraInfoString = Util.replaceAll(extraInfoString, "<p>", "\n\n");
            extraInfoString = Util.replaceAll(extraInfoString, "&uuml;", "\u00fc");
            extraInfoString = Util.replaceAll(extraInfoString, "&Uuml;", "\u00dc");
            extraInfoString = Util.replaceAll(extraInfoString, "&auml;", "\u00e4");
            extraInfoString = Util.replaceAll(extraInfoString, "&Auml;", "\u00c4");
            extraInfoString = Util.replaceAll(extraInfoString, "&ouml;", "\u00f6");
            extraInfoString = Util.replaceAll(extraInfoString, "&Ouml;", "\u00d6");
            extraInfoString = Util.replaceAll(extraInfoString, "&szlig;", "\u00df");
            extraInfoString = Util.replaceAll(extraInfoString, "&nbsp;", " ");
        } else {
            extraInfoString = Util.replaceAll(extraInfoString, "<br>", "");
            extraInfoString = Util.replaceAll(extraInfoString, "<p>", "");
            extraInfoString = Util.replaceAll(extraInfoString, "&nbsp;", "%20");
            extraInfoString = Util.replaceAll(extraInfoString, " ", "%20");
        }
        extraInfoString = Util.replaceAll(extraInfoString, "<html>", " ");
        extraInfoString = Util.replaceAll(extraInfoString, "</html>", " ");
        extraInfoString = Util.replaceAll(extraInfoString, "<font color=blue><u>", "");
        extraInfoString = Util.replaceAll(extraInfoString, "</u></font>", "");
        extraInfoString = extraInfoString.trim();
        StringSelection transfer = new StringSelection(extraInfoString);
        sysClip.setContents(transfer, null);
    }

    public void openURL() {
        String link = this.m_paymentLinkGenerator.createLink();
        AbstractOS os = AbstractOS.getInstance();
        link = Util.replaceAll(link, "<br>", "");
        link = Util.replaceAll(link, "<p>", "");
        link = Util.replaceAll(link, "<html>", " ");
        link = Util.replaceAll(link, "</html>", " ");
        link = Util.replaceAll(link, "&nbsp;", "%20");
        link = Util.replaceAll(link, " ", "%20");
        link = Util.replaceAll(link, "<font color=blue><u>", "");
        link = Util.replaceAll(link, "</u></font>", "");
        link = link.trim();
        LogHolder.log(7, LogType.PAY, "Opening " + link + " in browser.");
        try {
            URL urlToOpen = new URL(link);
            JAPController.getInstance().allowDirectProxyDomain(urlToOpen);
            os.openURL(urlToOpen);
        }
        catch (MalformedURLException me) {
            LogHolder.log(2, LogType.PAY, "Malformed URL");
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e != null) {
            if (e.getSource() == this.m_bttnCopy) {
                this.copyExtraInfoToClipboard();
            } else if (e.getSource() == this.m_bttnOpen) {
                this.openURL();
            }
        }
        this.m_bttnCopy.setEnabled(true);
    }

    public DialogContentPane.CheckError checkUpdate() {
        this.m_linkOpenedInBrowser.setSelected(false);
        this.showInfo();
        return null;
    }

    public DialogContentPane.CheckError checkYesOK() {
        if (!this.m_linkOpenedInBrowser.isSelected()) {
            if (this.m_bURL) {
                return new DialogContentPane.CheckError(JAPMessages.getString(MSG_EXPLAIN_COULD_OPEN));
            }
            return new DialogContentPane.CheckError(JAPMessages.getString(MSG_REMINDER_PAYMENT_EXPLAIN));
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

