/*
 * Decompiled with CFR 0.152.
 */
package jap.pay.wizardnew;

import anon.pay.BIConnection;
import anon.pay.PayAccount;
import anon.pay.PayAccountsFile;
import anon.pay.PaymentInstanceDBEntry;
import anon.pay.xml.XMLVolumePlan;
import anon.pay.xml.XMLVolumePlans;
import anon.util.JAPMessages;
import anon.util.Util;
import gui.GUIUtils;
import gui.JapCouponField;
import gui.dialog.DialogContentPane;
import gui.dialog.DialogContentPaneOptions;
import gui.dialog.JAPDialog;
import gui.dialog.WorkerContentPane;
import jap.JAPController;
import jap.JAPUtil;
import jap.gui.LinkRegistrator;
import jap.pay.AccountSettingsPanel;
import jap.pay.wizardnew.JpiSelectionPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import logging.LogHolder;
import logging.LogType;

public class VolumePlanSelectionPane
extends DialogContentPane
implements DialogContentPane.IWizardSuitable,
ActionListener,
DocumentListener {
    private static final String MSG_PRICE = (class$jap$pay$wizardnew$VolumePlanSelectionPane == null ? (class$jap$pay$wizardnew$VolumePlanSelectionPane = VolumePlanSelectionPane.class$("jap.pay.wizardnew.VolumePlanSelectionPane")) : class$jap$pay$wizardnew$VolumePlanSelectionPane).getName() + "_price";
    private static final String MSG_HEADING = (class$jap$pay$wizardnew$VolumePlanSelectionPane == null ? (class$jap$pay$wizardnew$VolumePlanSelectionPane = VolumePlanSelectionPane.class$("jap.pay.wizardnew.VolumePlanSelectionPane")) : class$jap$pay$wizardnew$VolumePlanSelectionPane).getName() + "_heading";
    private static final String MSG_VOLUME = (class$jap$pay$wizardnew$VolumePlanSelectionPane == null ? (class$jap$pay$wizardnew$VolumePlanSelectionPane = VolumePlanSelectionPane.class$("jap.pay.wizardnew.VolumePlanSelectionPane")) : class$jap$pay$wizardnew$VolumePlanSelectionPane).getName() + "_volume";
    private static final String MSG_UNLIMITED = (class$jap$pay$wizardnew$VolumePlanSelectionPane == null ? (class$jap$pay$wizardnew$VolumePlanSelectionPane = VolumePlanSelectionPane.class$("jap.pay.wizardnew.VolumePlanSelectionPane")) : class$jap$pay$wizardnew$VolumePlanSelectionPane).getName() + "_unlimited";
    private static final String MSG_ERROR_NO_PLAN_CHOSEN = (class$jap$pay$wizardnew$VolumePlanSelectionPane == null ? (class$jap$pay$wizardnew$VolumePlanSelectionPane = VolumePlanSelectionPane.class$("jap.pay.wizardnew.VolumePlanSelectionPane")) : class$jap$pay$wizardnew$VolumePlanSelectionPane).getName() + "_errorNoPlanChosen";
    private static final String MSG_VALIDUNTIL = (class$jap$pay$wizardnew$VolumePlanSelectionPane == null ? (class$jap$pay$wizardnew$VolumePlanSelectionPane = VolumePlanSelectionPane.class$("jap.pay.wizardnew.VolumePlanSelectionPane")) : class$jap$pay$wizardnew$VolumePlanSelectionPane).getName() + "_validuntil";
    private static final String MSG_CHOOSEAPLAN = (class$jap$pay$wizardnew$VolumePlanSelectionPane == null ? (class$jap$pay$wizardnew$VolumePlanSelectionPane = VolumePlanSelectionPane.class$("jap.pay.wizardnew.VolumePlanSelectionPane")) : class$jap$pay$wizardnew$VolumePlanSelectionPane).getName() + "_chooseaplan";
    private static final String MSG_ENTER_COUPON = (class$jap$pay$wizardnew$VolumePlanSelectionPane == null ? (class$jap$pay$wizardnew$VolumePlanSelectionPane = VolumePlanSelectionPane.class$("jap.pay.wizardnew.VolumePlanSelectionPane")) : class$jap$pay$wizardnew$VolumePlanSelectionPane).getName() + "_entercouponcode";
    private static final String MSG_PLAN_OR_COUPON = (class$jap$pay$wizardnew$VolumePlanSelectionPane == null ? (class$jap$pay$wizardnew$VolumePlanSelectionPane = VolumePlanSelectionPane.class$("jap.pay.wizardnew.VolumePlanSelectionPane")) : class$jap$pay$wizardnew$VolumePlanSelectionPane).getName() + "_planorcoupon";
    private static final String MSG_INVALID_COUPON = (class$jap$pay$wizardnew$VolumePlanSelectionPane == null ? (class$jap$pay$wizardnew$VolumePlanSelectionPane = VolumePlanSelectionPane.class$("jap.pay.wizardnew.VolumePlanSelectionPane")) : class$jap$pay$wizardnew$VolumePlanSelectionPane).getName() + "_invalidcoupon";
    private static final String MSG_COUPON_INCOMPLETE = (class$jap$pay$wizardnew$VolumePlanSelectionPane == null ? (class$jap$pay$wizardnew$VolumePlanSelectionPane = VolumePlanSelectionPane.class$("jap.pay.wizardnew.VolumePlanSelectionPane")) : class$jap$pay$wizardnew$VolumePlanSelectionPane).getName() + "_couponincomplete";
    private static final String MSG_ONE_TIME_PRICES = (class$jap$pay$wizardnew$VolumePlanSelectionPane == null ? (class$jap$pay$wizardnew$VolumePlanSelectionPane = VolumePlanSelectionPane.class$("jap.pay.wizardnew.VolumePlanSelectionPane")) : class$jap$pay$wizardnew$VolumePlanSelectionPane).getName() + ".oneTimePrices";
    private static final String MSG_TOTAL_PRICE = (class$jap$pay$wizardnew$VolumePlanSelectionPane == null ? (class$jap$pay$wizardnew$VolumePlanSelectionPane = VolumePlanSelectionPane.class$("jap.pay.wizardnew.VolumePlanSelectionPane")) : class$jap$pay$wizardnew$VolumePlanSelectionPane).getName() + ".totalPrice";
    private XMLVolumePlans m_allPlans;
    private XMLVolumePlan m_selectedPlan;
    private JapCouponField m_coupon1;
    private JapCouponField m_coupon2;
    private JapCouponField m_coupon3;
    private JapCouponField m_coupon4;
    private GridBagConstraints m_c = new GridBagConstraints();
    private Container m_rootPanel;
    private ButtonGroup m_rbGroup;
    private JRadioButton m_couponButton;
    private WorkerContentPane m_fetchPlansPane;
    private boolean m_bNewAccount;
    private boolean m_isCouponUsed;
    private boolean m_hasBeenShown = false;
    static /* synthetic */ Class class$jap$pay$wizardnew$VolumePlanSelectionPane;

    public VolumePlanSelectionPane(JAPDialog a_parentDialog, WorkerContentPane a_previousContentPane, boolean a_newAccount) {
        super(a_parentDialog, JAPMessages.getString(MSG_ONE_TIME_PRICES), new DialogContentPane.Layout(JAPMessages.getString(MSG_HEADING), -1), new DialogContentPaneOptions(2, (DialogContentPane)a_previousContentPane));
        this.setDefaultButtonOperation(266);
        this.m_fetchPlansPane = a_previousContentPane;
        this.m_bNewAccount = a_newAccount;
        this.m_rbGroup = new ButtonGroup();
        this.m_rootPanel = this.getContentPane();
        this.m_c = new GridBagConstraints();
        this.m_rootPanel.setLayout(new GridBagLayout());
        this.m_c.gridx = 0;
        this.m_c.gridy = 0;
        this.m_c.weightx = 0.0;
        this.m_c.weightx = 0.0;
        this.m_c.insets = new Insets(5, 5, 5, 5);
        this.m_c.anchor = 18;
        this.m_c.fill = 0;
        for (int i = 0; i < 10; ++i) {
            XMLVolumePlan dummyPlan = new XMLVolumePlan("dummy", "Dummy        for sizing", 100, 2, "months", 2000000L, 2000000L, true, null, false, true, 0.0);
            this.addPlan(dummyPlan);
        }
    }

    public XMLVolumePlan getSelectedVolumePlan() {
        return this.m_selectedPlan;
    }

    public String getEnteredCouponCode() {
        return this.getCouponString();
    }

    private void setCouponUsed(boolean curValue) {
        this.m_isCouponUsed = curValue;
    }

    public boolean isCouponUsed() {
        return this.m_isCouponUsed;
    }

    public boolean isCouponComplete() {
        return PayAccount.checkCouponCode(this.getCouponString()) != null;
    }

    public String getAmount() {
        int amount = this.m_selectedPlan.getPrice();
        Integer foo = new Integer(amount);
        String bar = foo.toString();
        return bar;
    }

    public String getCurrency() {
        return new String("EUR");
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JRadioButton) {
            JRadioButton clickedButton = (JRadioButton)e.getSource();
            String name = clickedButton.getName();
            if (name.equals("coupon")) {
                this.m_selectedPlan = null;
                this.setCouponUsed(true);
            } else if (this.m_allPlans != null) {
                this.m_selectedPlan = this.m_allPlans.getVolumePlan(name);
                this.clearCouponFields();
                this.setCouponUsed(false);
            }
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.m_selectedPlan = null;
        this.m_couponButton.setSelected(true);
        this.setCouponUsed(true);
    }

    public void removeUpdate(DocumentEvent e) {
    }

    public void changedUpdate(DocumentEvent e) {
    }

    private void addPlan(XMLVolumePlan aPlan) {
        JLabel planVolumeLbl;
        this.m_c.insets = new Insets(0, 5, 0, 5);
        ++this.m_c.gridy;
        String displayName = aPlan.getDisplayName();
        if (displayName == null || displayName.equals("")) {
            displayName = aPlan.getName();
        }
        String internalName = aPlan.getName();
        this.m_c.gridx = 0;
        JRadioButton rb = new JRadioButton(displayName);
        rb.setName(internalName);
        rb.addActionListener(this);
        this.m_rbGroup.add(rb);
        this.m_rootPanel.add((Component)rb, this.m_c);
        ++this.m_c.gridx;
        JLabel priceLbl = new JLabel(JAPUtil.formatEuroCentValue(aPlan.getPrice(), false));
        if (aPlan.isMonthlyVolume()) {
            priceLbl.setText(JAPUtil.formatEuroCentValue(aPlan.getPrice() / aPlan.getDuration(), false) + " / Monat");
        }
        priceLbl.setBorder(BorderFactory.createEmptyBorder(4, 0, 2, 0));
        this.m_rootPanel.add((Component)priceLbl, this.m_c);
        ++this.m_c.gridx;
        JLabel planDurationLbl = aPlan.isDurationLimited() ? new JLabel(JAPUtil.getDuration(aPlan.getDuration(), aPlan.getDurationUnit())) : new JLabel(JAPMessages.getString(MSG_UNLIMITED));
        planDurationLbl.setBorder(BorderFactory.createEmptyBorder(4, 0, 2, 0));
        this.m_rootPanel.add((Component)planDurationLbl, this.m_c);
        ++this.m_c.gridx;
        if (aPlan.isVolumeLimited()) {
            planVolumeLbl = new JLabel(Util.formatBytesValueWithUnit(aPlan.getVolumeKbytes() * 1000L));
            if (aPlan.isMonthlyVolume()) {
                planVolumeLbl.setText(JAPMessages.getString(AccountSettingsPanel.MSG_MONTHLY_VOLUME, planVolumeLbl.getText()));
            }
        } else {
            planVolumeLbl = new JLabel(JAPMessages.getString(MSG_UNLIMITED));
        }
        planVolumeLbl.setBorder(BorderFactory.createEmptyBorder(4, 0, 2, 0));
        this.m_rootPanel.add((Component)planVolumeLbl, this.m_c);
        ++this.m_c.gridx;
        priceLbl = new JLabel(JAPUtil.formatEuroCentValue(aPlan.getPrice(), true));
        priceLbl.setBorder(BorderFactory.createEmptyBorder(4, 0, 2, 0));
        this.m_rootPanel.add((Component)priceLbl, this.m_c);
    }

    private void addCouponField() {
        ++this.m_c.gridy;
        this.m_c.insets = new Insets(10, 5, 0, 5);
        this.m_c.gridx = 0;
        this.m_c.gridwidth = 4;
        JPanel couponHeaderPanel = new JPanel();
        this.m_couponButton = new JRadioButton("");
        this.m_couponButton.setName("coupon");
        this.m_couponButton.addActionListener(this);
        this.m_rbGroup.add(this.m_couponButton);
        couponHeaderPanel.add(this.m_couponButton);
        couponHeaderPanel.add(new JLabel(JAPMessages.getString(MSG_ENTER_COUPON)));
        this.m_rootPanel.add((Component)couponHeaderPanel, this.m_c);
        ++this.m_c.gridy;
        this.m_c.gridx = 0;
        this.m_c.gridwidth = 4;
        if (this.m_allPlans == null || this.m_allPlans.getNrOfPlans() == 0) {
            this.m_couponButton.setSelected(true);
            this.m_couponButton.setVisible(false);
        }
        JPanel couponPanel = new JPanel();
        this.m_coupon1 = new JapCouponField(true);
        this.m_coupon1.getDocument().addDocumentListener(this);
        couponPanel.add(this.m_coupon1);
        couponPanel.add(new JLabel(" - "));
        this.m_coupon2 = new JapCouponField(false);
        this.m_coupon1.setNextCouponField(this.m_coupon2);
        this.m_coupon2.getDocument().addDocumentListener(this);
        couponPanel.add(this.m_coupon2);
        couponPanel.add(new JLabel(" - "));
        this.m_coupon3 = new JapCouponField(false);
        this.m_coupon2.setNextCouponField(this.m_coupon3);
        this.m_coupon3.getDocument().addDocumentListener(this);
        couponPanel.add(this.m_coupon3);
        couponPanel.add(new JLabel(" - "));
        this.m_coupon4 = new JapCouponField(false);
        this.m_coupon3.setNextCouponField(this.m_coupon4);
        this.m_coupon4.getDocument().addDocumentListener(this);
        couponPanel.add(this.m_coupon4);
        PaymentInstanceDBEntry jpi = this.getPI();
        URL urlWebShop = null;
        if (jpi != null) {
            urlWebShop = jpi.getWebshopURL();
        }
        if (urlWebShop != null) {
            LinkRegistrator registrator = new LinkRegistrator(this.m_rootPanel, JAPController.getInstance().getView());
            registrator.addBrowserInstallationInfo(couponPanel, null, JAPMessages.getString(PayAccountsFile.MSG_DO_PREMIUM_PAYMENT), urlWebShop.toString(), false, 1);
        }
        this.m_rootPanel.add((Component)couponPanel, this.m_c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DialogContentPane.CheckError checkYesOK() {
        DialogContentPane.CheckError errors = super.checkYesOK();
        if (!this.m_couponButton.isSelected() && this.isCouponUsed()) {
            return new DialogContentPane.CheckError(JAPMessages.getString(MSG_PLAN_OR_COUPON));
        }
        if (this.m_rbGroup.getSelection() == null && !this.isCouponUsed()) {
            return new DialogContentPane.CheckError(JAPMessages.getString(MSG_ERROR_NO_PLAN_CHOSEN));
        }
        if (this.isCouponUsed() && !this.isCouponComplete()) {
            return new DialogContentPane.CheckError(JAPMessages.getString(MSG_COUPON_INCOMPLETE));
        }
        if (this.isCouponUsed() && this.isCouponComplete() && this.m_bNewAccount) {
            PaymentInstanceDBEntry jpi = this.getPI();
            DialogContentPane somePreviousPane = this.m_fetchPlansPane;
            while (!(somePreviousPane instanceof AccountSettingsPanel.AccountCreationPane)) {
                somePreviousPane = somePreviousPane.getPreviousContentPane();
            }
            AccountSettingsPanel.AccountCreationPane accountPane = (AccountSettingsPanel.AccountCreationPane)somePreviousPane;
            PayAccount account = (PayAccount)accountPane.getValue();
            boolean isValid = false;
            BIConnection piConn = null;
            try {
                try {
                    piConn = new BIConnection(jpi);
                    piConn.connect();
                    piConn.authenticate(account);
                    LogHolder.log(7, LogType.PAY, "Checking coupon code validity in VolumePlanSelectionPane");
                    isValid = piConn.checkCouponCode(this.getEnteredCouponCode(), account);
                }
                catch (Exception e) {
                    if (!Thread.currentThread().isInterrupted()) {
                        LogHolder.log(2, LogType.NET, "Error while checking coupon validity: ", e);
                        Thread.currentThread().interrupt();
                    }
                    Object var10_9 = null;
                    if (piConn != null) {
                        piConn.disconnect();
                    }
                }
                Object var10_8 = null;
                if (piConn != null) {
                    piConn.disconnect();
                }
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (piConn != null) {
                    piConn.disconnect();
                }
                throw throwable;
            }
            if (!PayAccountsFile.getInstance().isNewUserAllowed(this.getCouponString())) {
                return new DialogContentPane.CheckError(JAPMessages.getString(PayAccountsFile.MSG_ACTIVATING_COUPON_NOT_A_NEW_USER));
            }
            if (!isValid) {
                return new DialogContentPane.CheckError(JAPMessages.getString(MSG_INVALID_COUPON));
            }
        }
        return errors;
    }

    private PaymentInstanceDBEntry getPI() {
        DialogContentPane somePreviousPane = this.m_fetchPlansPane;
        while (!(somePreviousPane instanceof JpiSelectionPane)) {
            somePreviousPane = somePreviousPane.getPreviousContentPane();
        }
        JpiSelectionPane jpiPane = (JpiSelectionPane)somePreviousPane;
        PaymentInstanceDBEntry jpi = jpiPane.getSelectedPaymentInstance();
        return jpi;
    }

    public DialogContentPane.CheckError checkUpdate() {
        if (!this.m_hasBeenShown) {
            this.m_hasBeenShown = true;
            this.showVolumePlans();
        }
        return null;
    }

    public void showVolumePlans() {
        XMLVolumePlans allPlans;
        WorkerContentPane p = this.m_fetchPlansPane;
        Object value = p.getValue();
        this.m_allPlans = allPlans = (XMLVolumePlans)value;
        this.m_rootPanel.removeAll();
        this.m_c = new GridBagConstraints();
        this.m_c.gridx = 0;
        this.m_c.gridy = 0;
        this.m_c.weightx = 0.0;
        this.m_c.weightx = 0.0;
        this.m_c.insets = new Insets(5, 5, 5, 5);
        this.m_c.anchor = 18;
        this.m_c.fill = 0;
        ++this.m_c.gridx;
        JLabel label = new JLabel(JAPMessages.getString(MSG_PRICE) + " (Euro)");
        GUIUtils.setFontStyle(label, 1);
        this.m_rootPanel.add((Component)label, this.m_c);
        ++this.m_c.gridx;
        label = new JLabel(JAPMessages.getString(MSG_VALIDUNTIL));
        GUIUtils.setFontStyle(label, 1);
        this.m_rootPanel.add((Component)label, this.m_c);
        ++this.m_c.gridx;
        label = new JLabel(JAPMessages.getString(MSG_VOLUME));
        GUIUtils.setFontStyle(label, 1);
        this.m_rootPanel.add((Component)label, this.m_c);
        ++this.m_c.gridx;
        label = new JLabel(JAPMessages.getString(MSG_TOTAL_PRICE));
        GUIUtils.setFontStyle(label, 1);
        this.m_rootPanel.add((Component)label, this.m_c);
        this.m_rbGroup = new ButtonGroup();
        ++this.m_c.gridy;
        if (this.m_allPlans != null) {
            for (int i = 0; i < this.m_allPlans.getNrOfPlans(); ++i) {
                this.addPlan(this.m_allPlans.getVolumePlan(i));
            }
        }
        this.addCouponField();
    }

    public void resetSelection() {
        this.m_selectedPlan = null;
        this.clearCouponFields();
    }

    private void clearCouponFields() {
        this.m_coupon1.setText("");
        this.m_coupon2.setText("");
        this.m_coupon3.setText("");
        this.m_coupon4.setText("");
    }

    private String getCouponString() {
        return this.m_coupon1.getText() + this.m_coupon2.getText() + this.m_coupon3.getText() + this.m_coupon4.getText();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

