/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;

public class BEROctetString
extends ASN1OctetString {
    private static final int DEFAULT_CHUNK_SIZE = 1000;
    private int chunkSize;
    private ASN1OctetString[] octs;

    private static byte[] toBytes(ASN1OctetString[] octs) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        for (int i = 0; i != octs.length; ++i) {
            try {
                DEROctetString o = (DEROctetString)octs[i];
                bOut.write(o.getOctets());
                continue;
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(octs[i].getClass().getName() + " found in input should only contain DEROctetString");
            }
            catch (IOException e) {
                throw new IllegalArgumentException("exception converting octets " + e.toString());
            }
        }
        return bOut.toByteArray();
    }

    public BEROctetString(byte[] string) {
        this(string, 1000);
    }

    public BEROctetString(ASN1OctetString[] octs) {
        this(octs, 1000);
    }

    public BEROctetString(byte[] string, int chunkSize) {
        this(string, null, chunkSize);
    }

    public BEROctetString(ASN1OctetString[] octs, int chunkSize) {
        this(BEROctetString.toBytes(octs), octs, chunkSize);
    }

    private BEROctetString(byte[] string, ASN1OctetString[] octs, int chunkSize) {
        super(string);
        this.octs = octs;
        this.chunkSize = chunkSize;
    }

    public Enumeration getObjects() {
        if (this.octs == null) {
            return this.generateOcts().elements();
        }
        return new Enumeration(){
            int counter = 0;

            public boolean hasMoreElements() {
                return this.counter < BEROctetString.this.octs.length;
            }

            public Object nextElement() {
                return BEROctetString.this.octs[this.counter++];
            }
        };
    }

    private Vector generateOcts() {
        Vector<DEROctetString> vec = new Vector<DEROctetString>();
        for (int i = 0; i < this.string.length; i += this.chunkSize) {
            int end = Math.min(this.string.length, i + this.chunkSize);
            byte[] nStr = new byte[end - i];
            System.arraycopy(this.string, i, nStr, 0, nStr.length);
            vec.addElement(new DEROctetString(nStr));
        }
        return vec;
    }

    boolean isConstructed() {
        return true;
    }

    int encodedLength() throws IOException {
        int length = 0;
        Enumeration e = this.getObjects();
        while (e.hasMoreElements()) {
            length += ((ASN1Encodable)e.nextElement()).toASN1Primitive().encodedLength();
        }
        return 2 + length + 2;
    }

    public void encode(ASN1OutputStream out) throws IOException {
        out.writeObject(this);
    }

    void encode(ASN1OutputStream out, boolean withTag) throws IOException {
        out.writeEncodedIndef(withTag, 36, this.getObjects());
    }

    static BEROctetString fromSequence(ASN1Sequence seq) {
        int count = seq.size();
        ASN1OctetString[] v = new ASN1OctetString[count];
        for (int i = 0; i < count; ++i) {
            v[i] = ASN1OctetString.getInstance(seq.getObjectAt(i));
        }
        return new BEROctetString(v);
    }
}

