/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util;

import java.math.BigInteger;
import java.security.Security;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.bouncycastle.util.Strings;

public class Properties {
    private Properties() {
    }

    public static boolean isOverrideSet(String propertyName) {
        String p = Properties.getPropertyValue(propertyName);
        return "true".equalsIgnoreCase(p);
    }

    public static BigInteger asBigInteger(String propertyName) {
        String p = Properties.getPropertyValue(propertyName);
        if (p != null) {
            return new BigInteger(p);
        }
        return null;
    }

    public static Set asKeySet(String propertyName) {
        HashSet<String> set = new HashSet<String>();
        String p = Properties.getPropertyValue(propertyName);
        if (p != null) {
            StringTokenizer sTok = new StringTokenizer(p, ",");
            while (sTok.hasMoreElements()) {
                set.add(Strings.toLowerCase(sTok.nextToken()).trim());
            }
        }
        return Collections.unmodifiableSet(set);
    }

    public static String getPropertyValue(String propertyName) {
        String val = Security.getProperty(propertyName);
        if (val != null) {
            return val;
        }
        return System.getProperty(propertyName);
    }
}

